//Aim:To design prototype Band Pass filter.
//Software version Scilab 5.5.2
//OS Windows 7

clear;
clc;
R0=600;//Nominal characteristic impedance in ohms.
disp('ohms',R0,'Considered value of nominal characteristic impedence : R0 = ')
fc=10^4;//Cutoff frequency in Hz.
f2=5000;//Upper cutoff frequency in Hz.
f1=2000;//Lower cutoff frequency in Hz.
L1=R0/(%pi*(f2-f1));
disp('H',L1,'L1=')
L=L1/2;
disp('H',L,'L1/2=')
C1=(f2-f1)/(4*%pi*R0*f1*f2);
disp('F',C1,'C1=')
C=2*C1;
disp('F',C,'2*C1=')
L2=(R0*(f2-f1))/(4*%pi*f1*f2);
disp('H',L2,'L2=')
C2=1/(%pi*R0*(f2-f1));
disp('F',C2,'C2=')

//We will now check whether our design is correct or not
//For bandpass filter,we have the relation :
// R0=sqrt(L2/C1)=sqrt(L1/C2)
//Let 
R01=sqrt(L2/C1);
R02=sqrt(L1/C2);
disp('ohms',R01,'R01=')
disp('ohms',R02,'R02=')
if R01==R02 then
    R0new=R01
    disp('So, R01=R02')
else
    disp('Design is not correct')
end
if R0new==R0 then
    disp('Since R01=R02=R0 ,it indicates that the calculated values of the nominal characteristic impedence')
    disp('are the same as the considered value of the nominal characteristic impedence,')
    disp('and so our design is perfect')
else
    disp('Design is not correct')
end
